package main

import (
	"errors"
	"fmt"
	"image"
	"image/png"
	"net/http"
	"os"
	"time"
)

func main() {
	f, err := os.Open("img.png")
	if err != nil {
		panic(err)
	}

	img, err := png.Decode(f)
	if err != nil {
		panic(err)
	}

	for {
		<-time.After(5 * time.Second)

		if err := draw(img); err != nil {
			fmt.Println(err)
		}
	}
}

func draw(img image.Image) error {
	req, err := http.NewRequest("GET", "https://cqql.site/chaosbtn", nil)
	if err != nil {
		return err
	}

	res, err := http.DefaultClient.Do(req)
	if err != nil {
		return err
	}
	defer res.Body.Close()

	if res.StatusCode != 200 {
		return errors.New("could not fetch current button state")
	}

	currentState, err := png.Decode(res.Body)
	if err != nil {
		return err
	}

	for x := 0; x < 88; x++ {
		for y := 0; y < 31; y++ {
			r, g, b, _ := img.At(x, y).RGBA()
			curR, curG, curB, _ := currentState.At(x, y).RGBA()

			if r == curR && g == curG && b == curB {
				fmt.Printf("skip [%02d,%02d]\n", x, y)
				continue
			}

			uri := fmt.Sprintf("https://cqql.site/chaosbtn/draw?x=%d&y=%d&r=%d&g=%d&b=%d", x, y, r/257, g/257, b/257)
			fmt.Printf("send [%02d,%02d] [%03d %03d %03d]\n", x, y, r/257, g/257, b/257)

			req, err := http.NewRequest("GET", uri, nil)
			if err != nil {
				return err
			}

			_, err = http.DefaultClient.Do(req)
			if err != nil {
				return err
			}
		}
	}

	return nil
}
